function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 129);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(59));
T(3) = exp(y(18))^params(3);
T(4) = exp(y(54));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(49));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(52))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(59))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(59))*(1-params(11))*params(3);
T(19) = exp(y(18))^(params(3)-1);
T(20) = exp(y(53));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(115));
T(24) = exp(y(58));
T(25) = exp(y(55))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(15));
T(27) = exp(y(20))-params(9)*exp(y(19))^(1+params(8))/(1+params(8));
T(28) = T(27)^(-params(15));
T(29) = params(14)^(1-params(4));
T(30) = params(13)^(1-params(4));
T(31) = params(12)^(1-params(4));
T(32) = exp(y(34));
T(33) = T(26)*exp(y(30))*T(32);
T(34) = params(23)^(-1);
T(35) = T(34)*y(23)*(-(T(24)*exp(y(30))*exp(y(16))));
T(36) = T(34)*y(26)*(-(T(24)*exp(y(30))*exp(y(14)-y(60))));
T(37) = exp(y(30))*y(69)+T(35)+T(34)*y(25)*(-(exp(y(30))*T(24)))+T(36)+T(34)*y(28)*(-(exp(y(30))*T(24)*exp((-y(60)))));
T(38) = exp(y(31))/(exp(y(31))+exp(y(33)));
T(39) = exp(y(33))/(exp(y(31))+exp(y(33)));
T(40) = exp(y(30))*T(32)-T(32)*params(6)*exp(y(67)-y(60))^(params(5)-1);
T(41) = T(32)/(T(32)+exp(y(35)));
T(42) = exp(y(35))/(T(32)+exp(y(35)));
T(43) = params(23)*y(131)*(-(exp(y(37))*exp((-y(117)))*exp(y(44))));
T(44) = exp(y(37))*y(85)+params(23)*y(122)*exp(y(37))*params(6)*exp(params(5)*(y(44)-y(117)))+params(23)*y(125)*(-(exp(y(37))*(1-exp((-y(117)))*exp(y(44)))))+T(43);
T(45) = params(23)*y(130)*(-(exp(y(45))*exp(y(38))));
T(46) = exp(y(38))*y(84)+params(23)*y(122)*params(6)*exp(params(5)*y(45))*exp(y(38))+params(23)*y(124)*(-((1-exp(y(45)))*exp(y(38))))+T(45);
T(47) = params(23)*y(132)*(-(exp(y(39))*exp((-y(117)))*exp(y(43))));
T(48) = exp(y(39))*y(86)+params(23)*y(122)*params(6)*exp(params(5)*(y(43)-y(117)))*exp(y(39))+params(23)*y(126)*(-(exp(y(39))*(1-exp((-y(117)))*exp(y(43)))))+T(47);
T(49) = exp(y(40))*y(88)+y(85)*(-(params(7)*exp(y(40))))+params(23)*y(128)*(-((1-params(7))*exp(y(40))));
T(50) = exp(y(41))*y(87)+y(84)*(-(params(7)*exp(y(41))))+params(23)*y(127)*(-((1-params(7))*exp(y(41))));
T(51) = exp(y(42))*y(89)+y(86)*(-(params(7)*exp(y(42))))+params(23)*y(129)*(-((1-params(7))*exp(y(42))));
T(52) = T(23)*params(6)*params(5)*(params(5)-1)*exp((params(5)-1)*(y(43)-y(117)));
T(53) = exp(y(105))*exp(y(43)-y(117))+y(109)*(-exp(y(43)-y(117)));
T(54) = (-(T(23)*(T(53)-params(6)*params(5)*exp(params(5)*(y(43)-y(117))))));
T(55) = y(80)*T(54);
T(56) = params(23)*y(126)*(-(exp(y(39))*(-(exp((-y(117)))*exp(y(43))))));
T(57) = params(23)*y(125)*(-(exp(y(37))*(-(exp((-y(117)))*exp(y(44))))));
T(58) = T(43)+params(23)*y(122)*exp(y(37))*params(6)*params(5)*exp(params(5)*(y(44)-y(117)))+T(57);
T(59) = T(23)*params(6)*params(5)*(params(5)-1)*exp(y(45)*(params(5)-1));
T(60) = (-(T(23)*(exp(y(45))*exp(y(105))+y(106)*(-exp(y(45)))-params(6)*params(5)*exp(params(5)*y(45)))));
T(61) = params(23)*y(124)*(-(exp(y(38))*(-exp(y(45)))));
T(62) = T(8)*getPowerDeriv(T(8),T(13),1);
T(63) = T(8)*getPowerDeriv(T(8),T(1),1);
T(64) = getPowerDeriv(T(9),T(10),1);
T(65) = exp(y(52))*getPowerDeriv(exp(y(52)),T(11),1);
T(66) = exp(T(1)*y(59))*(1-params(11))*params(3)*T(65);
T(67) = exp(T(1)*y(59))*(1-params(11))*(1-params(3))*T(65);
T(68) = (1-params(11))*exp(T(1)*y(116));
T(69) = exp(y(112))^(1-params(3));
T(70) = T(20)*getPowerDeriv(T(20),params(3),1);
T(71) = T(20)^params(3);
T(72) = T(69)*T(71);
T(73) = getPowerDeriv(T(72),T(1),1);
T(74) = T(68)*T(69)*T(70)*T(73);
T(75) = T(72)^T(1);
T(76) = T(68)*T(75)+params(11)*exp(y(108))^T(1);
T(77) = getPowerDeriv(T(76),T(10),1);
T(78) = exp(y(112))^(-params(3));
T(79) = exp(y(111))^T(11);
T(80) = T(79)*(1-params(11))*(1-params(3))*exp(T(1)*y(116));
T(81) = T(72)^T(13);
T(82) = getPowerDeriv(T(72),T(13),1);
T(83) = T(69)*T(70)*T(82);
T(84) = T(20)^(params(3)-1);
T(85) = T(79)*(1-params(11))*params(3)*exp(T(1)*y(116));
T(86) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(87) = (-(T(69)*(T(84)*T(83)*T(85)+T(81)*T(85)*T(86))));
T(88) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(89) = (-(params(9)*T(88)/(1+params(8))));
T(90) = getPowerDeriv(T(25),(-params(15)),1);
T(91) = T(89)*T(90);
T(92) = (1-params(3))*exp(y(54)*(1-params(3)));
T(93) = (-(exp(T(1)*y(59))*exp(y(18)*params(3))*T(92)));
T(94) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(95) = getPowerDeriv(T(6),T(13),1);
T(96) = T(3)*T(94)*T(95);
T(97) = (-(T(16)*T(18)*T(19)*T(94)+T(5)*T(19)*T(18)*T(96)));
T(98) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(99) = (-(T(17)*T(3)*T(15)*T(96)+T(3)*T(15)*T(16)*T(98)));
T(100) = getPowerDeriv(T(6),T(1),1);
T(101) = T(2)*T(3)*T(94)*T(100);
T(102) = exp(y(113))-params(9)*exp(y(112))^(1+params(8))/(1+params(8));
T(103) = params(1)*T(102)^(-params(15));
T(104) = exp(y(55))*T(90);
T(105) = (-(params(1)*T(104)/T(28)));
T(106) = exp(y(57))*getPowerDeriv(exp(y(57)),T(22),1);
T(107) = T(34)*y(28)*(T(24)*params(6)*params(5)*exp((y(14)-y(60))*(params(5)-1))-T(24)*exp((-y(60)))*(exp(y(30))-y(50)))+T(34)*y(25)*(T(24)*params(6)*params(5)*exp(y(16)*(params(5)-1))-T(24)*(exp(y(30))-y(47)))+T(24)*y(75)+T(34)*y(22)*(-(T(24)*(1+exp(y(56))-params(10))))+T(34)*y(23)*(-(T(24)*(exp(y(30))*exp(y(16))+y(47)*(1-exp(y(16)))-params(6)*exp(params(5)*y(16)))))+T(34)*y(24)*(-(y(48)*T(24)*(1-params(7))))+T(34)*y(26)*(-(T(24)*(exp(y(30))*exp(y(14)-y(60))+y(50)*(1-exp(y(14)-y(60)))-params(6)*exp(params(5)*(y(14)-y(60))))))+T(34)*y(27)*(-(y(51)*T(24)*(1-params(7))));
T(108) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59));
T(109) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59));
T(110) = (1-params(11))*T(1)*exp(T(1)*y(59));
T(111) = T(7)*T(110);
T(112) = params(23)^2;
T(113) = getPowerDeriv(exp(y(67)-y(60)),params(5)-1,1);
T(114) = (-(T(32)*params(6)*(-exp(y(67)-y(60)))*T(113)));
T(115) = T(26)*T(114);
T(116) = (-(exp(y(10))*exp(y(14))*(-exp((-y(60))))));
T(117) = y(92)*T(116);
T(118) = (-(exp(y(8))*exp(y(15))*(-exp((-y(60))))));
T(119) = y(91)*T(118);
T(120) = (-(exp(y(10))*(-(exp(y(14))*(-exp((-y(60))))))));
T(121) = y(86)*T(120);
T(122) = (-(exp(y(8))*(-(exp(y(15))*(-exp((-y(60))))))));
T(123) = exp(y(8))*params(6)*exp(params(5)*(y(15)-y(60)))*(-params(5))+exp(y(10))*params(6)*exp(params(5)*(y(14)-y(60)))*(-params(5));
T(124) = exp(y(30))*(-exp(y(14)-y(60)))+y(50)*exp(y(14)-y(60));
T(125) = (-(T(24)*(T(124)-params(6)*exp(params(5)*(y(14)-y(60)))*(-params(5)))));
T(126) = T(34)*y(26)*T(125);
T(127) = T(34)*y(28)*(T(24)*params(6)*params(5)*exp((y(14)-y(60))*(params(5)-1))*(-(params(5)-1))-(exp(y(30))-y(50))*T(24)*(-exp((-y(60)))));
T(128) = (-(T(32)*params(6)*exp(y(67)-y(60))*T(113)));
T(129) = T(23)*params(6)*params(5)*exp((params(5)-1)*(y(43)-y(117)))-T(23)*exp((-y(117)))*(exp(y(105))-y(109));

end
